/*
USAGE:
	Open a command prompt in the website's folder  (I usually right-click and select "Git Bash")
	In the command prompt, type "node server.js"
	(Now the server is running)
	Open a web browser anywhere in the local network
	Type:
		192.168.2.212:8090/index.htm
			(server computer's IP addesss : 8090)
			(/index.htm is required because NodeJS will refuse to display directory listings. Attempting a directory listing results in "Cannot GET /")
			
TO STOP:
	Select the command prompt, and press CTRL+C
*/



// __dirname 
var webDir = process.argv[2] || __dirname;
var viewUrl = process.argv[3] || "";
console.log("Now serving:  "+webDir);
console.log("As:  http://localhost:8090");
console.log("Press CTRL+C to stop this server.");
var express = require('express');
var open = require('open');
var app = express();
app.configure(function () {
	app.use(express.directory( webDir ));
    app.use(
        "/", //the URL through which you want to access to you static content
        express.static( webDir ) //where your static content is located in your filesystem
    );
});
app.listen(8090); //the port you want to use
open("http://localhost:8090"+viewUrl );